#include "af901x.h"
#include "dvb_frontend.h"

struct af901xm_state {
	struct dvb_frontend demod;
	fe_bandwidth_t current_bandwidth;
};

static int af901x_set_bandwidth(struct dvb_frontend *demod, u8 bw_idx)
{
	struct af901xm_state *state = demod->demodulator_priv;

	deb_data("SB %s - %d \n",__FUNCTION__,bw_idx);

	state->current_bandwidth = bw_idx;

	Do_Tuner_SetBW(bw_idx);

	return 0;
}

static void af901x_set_channel(struct af901x_ofdm_channel *ch)
{

	deb_data("%s - RF=%d, BW=%d\n",__FUNCTION__,ch->RF_kHz,ch->Bw);

	Do_Tuner_SetFreq(ch->RF_kHz,ch->Bw);
}

static int af901x_tune(struct dvb_frontend *demod, struct af901x_ofdm_channel *ch)
{
	if (ch != NULL)
		af901x_set_channel(ch);

	return 0;
}

static int af901x_init(struct dvb_frontend *demod)
{

	deb_data("%s\n",__FUNCTION__);

	Do_Tuner_Init(1);

	return 0;
}

static int af901x_sleep(struct dvb_frontend *demod)
{
	return 0;
}

static int af901x_identify(struct af901xm_state *state)
{
	return 0;
}

static int af901x_get_frontend(struct dvb_frontend* fe,
				struct dvb_frontend_parameters *fep)
{
	struct af901xm_state *state = fe->demodulator_priv;
	fep->inversion = INVERSION_AUTO;
	fep->u.ofdm.bandwidth = state->current_bandwidth;
	return 0;
}

static int af901x_set_frontend(struct dvb_frontend* fe,
				struct dvb_frontend_parameters *fep)
{
	struct af901xm_state *state = fe->demodulator_priv;
	struct af901x_ofdm_channel ch;

	if (fep->u.ofdm.bandwidth == 0) fep->u.ofdm.bandwidth=8;
	if (fep->u.ofdm.bandwidth == 1) fep->u.ofdm.bandwidth=7;
	if (fep->u.ofdm.bandwidth == 2) fep->u.ofdm.bandwidth=6;

	ch.RF_kHz           = fep->frequency / 1000;
	ch.Bw               = fep->u.ofdm.bandwidth;

	state->current_bandwidth = fep->u.ofdm.bandwidth;

	af901x_set_bandwidth(fe, fep->u.ofdm.bandwidth);

	return af901x_tune(fe, &ch);
}

static int af901x_read_status(struct dvb_frontend *fe, fe_status_t *stat)
{
	//struct af901xm_state *state = fe->demodulator_priv;

	*stat = 0;
	// It's seems ok that always return lock to AP
	*stat |= FE_HAS_SIGNAL;
	*stat |= FE_HAS_CARRIER;
	*stat |= FE_HAS_LOCK;
	*stat |= FE_HAS_VITERBI;
	*stat |= FE_HAS_SYNC;

	return 0;
}

static int af901x_read_ber(struct dvb_frontend *fe, u32 *ber)
{
	return 0;
}

static int af901x_read_signal_strength(struct dvb_frontend *fe, u16 *strength)
{
	return 0;
}

static int af901x_read_snr(struct dvb_frontend* fe, u16 *snr)
{
	*snr = 0x0000;
	return 0;
}

static void af901x_release(struct dvb_frontend *demod)
{
	struct af901xm_state *st = demod->demodulator_priv;
	kfree(st);
}

static struct dvb_frontend_ops af901x_ops;
struct dvb_frontend * af901x_attach(u8 tmp)
{
	struct dvb_frontend *demod;
	struct af901xm_state *st;
	
	st = kzalloc(sizeof(struct af901xm_state), GFP_KERNEL);
	if (st == NULL)
		return NULL;

	demod                   = &st->demod;
	demod->demodulator_priv = st;
	memcpy(&st->demod.ops, &af901x_ops, sizeof(struct dvb_frontend_ops));

	af901x_identify(st); 

	return demod;
}
EXPORT_SYMBOL(af901x_attach);

static struct dvb_frontend_ops af901x_ops = {
	.info = {
		.name = "AF901X USB DVB-T",
		.type = FE_OFDM,
		.frequency_min      = 44250000,
		.frequency_max      = 867250000,
		.frequency_stepsize = 62500,
		.caps = FE_CAN_INVERSION_AUTO |
			FE_CAN_FEC_1_2 | FE_CAN_FEC_2_3 | FE_CAN_FEC_3_4 |
			FE_CAN_FEC_5_6 | FE_CAN_FEC_7_8 | FE_CAN_FEC_AUTO |
			FE_CAN_QPSK | FE_CAN_QAM_16 | FE_CAN_QAM_64 | FE_CAN_QAM_AUTO |
			FE_CAN_TRANSMISSION_MODE_AUTO |
			FE_CAN_GUARD_INTERVAL_AUTO |
			FE_CAN_RECOVER |
			FE_CAN_HIERARCHY_AUTO,
	},

	.release              = af901x_release,

	.init                 = af901x_init,
	.sleep                = af901x_sleep,

	.set_frontend         = af901x_set_frontend,
	.get_frontend         = af901x_get_frontend,

	.read_status          = af901x_read_status,
	.read_ber             = af901x_read_ber,
	.read_signal_strength = af901x_read_signal_strength,
	.read_snr             = af901x_read_snr,
};

MODULE_AUTHOR("Rick Huang <rick_huang@afatech.com.tw>");
MODULE_DESCRIPTION("Driver for the AF901X demodulator");
MODULE_LICENSE("GPL");
